USE BMS

IF (SELECT count(*) FROM information_schema.columns WHERE table_name = 'DISCHARGE_INT' and COLUMN_NAME = 'STATUS' AND CHARACTER_MAXIMUM_LENGTH = 200) = 0
BEGIN
   ALTER TABLE DISCHARGE_INT
   ALTER COLUMN [STATUS] NVARCHAR(200) NULL
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_REQUESTED_DATE_COMPLETED_DATE' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_REQUESTED_DATE_COMPLETED_DATE] ON [dbo].[BED_CLEAN] 
	(
		[REQUESTED_DATE] ASC,
		[COMPLETED_DATE] ASC
	)
	INCLUDE ([ID],
	[DOMAIN_ID],
	[BED_UID],
	[WARD_UID],
	[EVENT_IEN]) 
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_HAS_DISCHARGE_ID_BED_UID_WARD_UID_ADMISSION_DATE' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_HAS_DISCHARGE_ID_BED_UID_WARD_UID_ADMISSION_DATE] ON [dbo].[ADMISSION_EVN] 
	([HAS_DISCHARGE])
	INCLUDE ([ID],[BED_UID],[WARD_UID],[ADMISSION_DATE])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_PATIENT_UID' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_PATIENT_UID] ON [dbo].[ADMISSION_EVN] 
	([PATIENT_UID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_ADMISSION_ID_IEN' AND object_id = OBJECT_ID('MOVEMENT_EVN')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_ADMISSION_ID_IEN] ON [dbo].[MOVEMENT_EVN] 
	([ADMISSION_ID] ASC, [IEN] ASC)
	INCLUDE ( [BED_UID],[MOVEMENT_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_ID_DOMAIN_ID_IEN' AND object_id = OBJECT_ID('DISCHARGE_EVN')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID_ID_DOMAIN_ID_IEN] ON [dbo].[DISCHARGE_EVN] ([VISTA_SITE_UID])
	INCLUDE ([ID],[DOMAIN_ID],[IEN])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_REMOVE_DATE_ACT_ID' AND object_id = OBJECT_ID('WAITING_LIST')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_REMOVE_DATE_ACT_ID] ON [dbo].[WAITING_LIST] ([REMOVED_DATE])
	INCLUDE ([ACT_ID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('MOVEMENT_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID]
	ON [dbo].[MOVEMENT_REQ] ([IS_ACTIVE] ASC, [PATIENT_UID] ASC, [WARD_UID] ASC, [VISTA_SITE_UID] ASC)
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IEN_VISTA_SITE_UID' AND object_id = OBJECT_ID('MOVEMENT_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_IEN_VISTA_SITE_UID] ON [dbo].[MOVEMENT_REQ] ([IEN] ASC, [VISTA_SITE_UID] ASC)
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_ORDERABLE_ITEM_ID_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_ORDERABLE_ITEM_ID_PATIENT_UID_WARD_UID_VISTA_SITE_UID]
	ON [dbo].[DISCHARGE_REQ] ([IS_ACTIVE] ASC, [ORDERABLE_ITEM_ID] ASC, [PATIENT_UID] ASC, [WARD_UID] ASC, [VISTA_SITE_UID] ASC)
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IEN_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_IEN_VISTA_SITE_UID] 
	ON [dbo].[DISCHARGE_REQ] ([IEN] ASC, [VISTA_SITE_UID] ASC)
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_INT')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID] 
	ON [dbo].[DISCHARGE_INT] ([APPOINTMENT_DATE] ASC, [PATIENT_UID] ASC, [VISTA_SITE_UID] ASC)
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_INT')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID]
	ON [dbo].[DISCHARGE_INT] ([APPOINTMENT_DATE] ASC, [STATUS] ASC, [IS_ACTIVE] ASC, [PATIENT_UID] ASC, [WARD_UID] ASC, [VISTA_SITE_UID] ASC)
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_ORDER_ID_FACILITY_UID_ORDER_TYPE' AND object_id = OBJECT_ID('ORDER_FACILITY')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_ORDER_ID_FACILITY_UID_ORDER_TYPE] ON [dbo].[ORDER_FACILITY] 
	(
		[ORDER_ID] ASC,
		[FACILITY_UID] ASC,
		[ORDER_TYPE] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_CLEAN] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('BED_REASON_COMMENT_HISTORY')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_REASON_COMMENT_HISTORY] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('BED_STAFF')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_STAFF] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('BED_SWITCH')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_SWITCH] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('BED_UNAVAILABLE')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_UNAVAILABLE] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('DISCHARGE_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[DISCHARGE_EVN] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('ICON_ASSOCIATION')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[ICON_ASSOCIATION] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('ICON_FLAG_FACILITY')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[ICON_FLAG_FACILITY] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('ORDER_FACILITY')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[ORDER_FACILITY] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_DELETE_TIME' AND object_id = OBJECT_ID('ORDER_FACILITY_ssisdel')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_DELETE_TIME] ON [dbo].[ORDER_FACILITY_ssisdel] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO


IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('SCHEDULED_ADMISSION')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[SCHEDULED_ADMISSION] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_DELETE_TIME' AND object_id = OBJECT_ID('SCHEDULED_ADMISSION_ssisdel')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_DELETE_TIME] ON [dbo].[SCHEDULED_ADMISSION_ssisdel] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_SSIS_MODIFY' AND object_id = OBJECT_ID('WAITING_LIST')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[WAITING_LIST] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_DELETE_TIME' AND object_id = OBJECT_ID('WAITING_LIST_ssisdel')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_DELETE_TIME] ON [dbo].[WAITING_LIST_ssisdel] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE' AND object_id = OBJECT_ID('ADMISSION_REQ')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE] ON [dbo].[ADMISSION_REQ] 
(
	[RELEASED_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ( [ID]) 
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_WARD_UID_ENTERED_DATE_ADMISSION_DATE' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_WARD_UID_ENTERED_DATE_ADMISSION_DATE] ON [dbo].[ADMISSION_EVN] 
(
	[WARD_UID] ASC,
	[ENTERED_DATE] ASC,
	[ADMISSION_DATE] ASC
)
INCLUDE ( [CREATION_UTC_DATE]) 
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE' AND object_id = OBJECT_ID('MOVEMENT_REQ')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE] ON [dbo].[MOVEMENT_REQ] 
(
	[RELEASED_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_RELEASED_DATE_CREATION_UTC_DATE_ORDERABLE_ITEM_IS_ACTIVE' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_RELEASED_DATE_CREATION_UTC_DATE_ORDERABLE_ITEM_IS_ACTIVE] ON [dbo].[DISCHARGE_REQ] 
(
	[RELEASED_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[ORDERABLE_ITEM_ID] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_RELEASED_DATE_CREATION_UTC_DATE_IS_ACTIVE] ON [dbo].[DISCHARGE_REQ] 
(
	[RELEASED_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ( [ID],[ORDER_TEXT]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_FILTERED_ACTIVE_ADMISSION_BY_BED_PATIENT_WARD' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_FILTERED_ACTIVE_ADMISSION_BY_BED_PATIENT_WARD] ON [dbo].[ADMISSION_EVN] 
(
	[HAS_DISCHARGE] ASC,
	[BED_UID] ASC,
	[PATIENT_UID] ASC,
	[WARD_UID] ASC
)
INCLUDE ( [IEN]) 
WHERE ([HAS_DISCHARGE]=(0))
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_DATE_ENTERED_APPOINTMENT_DATE_CREATION_UTC_DATE_IS_ACTIVE' AND object_id = OBJECT_ID('DISCHARGE_INT')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_DATE_ENTERED_APPOINTMENT_DATE_CREATION_UTC_DATE_IS_ACTIVE] ON [dbo].[DISCHARGE_INT] 
(
	[DATE_ENTERED] ASC,
	[APPOINTMENT_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ([ID], [HOSPITAL_LOCATION_UID], [WARD_UID], [PATIENT_UID] ) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_WARD_UID_ENTERED_DATE_DISCHARGED_DATE' AND object_id = OBJECT_ID('DISCHARGE_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_WARD_UID_ENTERED_DATE_DISCHARGED_DATE] ON [dbo].[DISCHARGE_EVN] 
(
	[WARD_UID] ASC,
	[ENTERED_DATE] ASC,
	[DISCHARGED_DATE] ASC
)
INCLUDE ( [CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_ACCEPTED_DATE_COMPLETED_DATE' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_ACCEPTED_DATE_COMPLETED_DATE] ON [dbo].[BED_CLEAN] 
(
	[ACCEPTED_DATE] ASC,
	[COMPLETED_DATE] ASC,
	[REQUESTED_DATE] ASC,
	[VACATED_DATE] ASC,
	[EVENT_IEN] ASC
)
INCLUDE ( [WARD_UID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_COMPLETED_DATE_ACCEPTED_DATE' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_COMPLETED_DATE_ACCEPTED_DATE] ON [dbo].[BED_CLEAN] 
(
	[COMPLETED_DATE] ASC,
	[ACCEPTED_DATE] ASC,
	[REQUESTED_DATE] ASC,
	[VACATED_DATE] ASC,
	[EVENT_IEN] ASC
)
INCLUDE ( [WARD_UID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_COMPLETED_DATE_COMPLETED_BY_REQUESTED_DATE' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_COMPLETED_DATE_COMPLETED_BY_REQUESTED_DATE] ON [dbo].[BED_CLEAN] 
(
	[COMPLETED_DATE] ASC,
	[COMPLETED_BY] ASC,
	[REQUESTED_DATE] ASC
)
INCLUDE ( [WARD_UID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_FACILITY_UID_ORDER_TYPE' AND object_id = OBJECT_ID('ORDER_FACILITY')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_FACILITY_UID_ORDER_TYPE]
ON [dbo].[ORDER_FACILITY] ([FACILITY_UID],[ORDER_TYPE])
INCLUDE ([ORDER_ID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_FILTERED_ACTIVE_ADMISSION_BY_VISTA_SITE_UID' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_FILTERED_ACTIVE_ADMISSION_BY_VISTA_SITE_UID] ON [dbo].[ADMISSION_EVN] 
(
	[HAS_DISCHARGE] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [ID],
[BED_UID],
[ADMISSION_DATE],
[DOMAIN_ID]) 
WHERE ([HAS_DISCHARGE]=(0))
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_FILTERED_ACTIVE_ADMISSION_BY_WARD_UID' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_FILTERED_ACTIVE_ADMISSION_BY_WARD_UID] ON [dbo].[ADMISSION_EVN] 
(
	[HAS_DISCHARGE] ASC,
	[WARD_UID] ASC
)
INCLUDE ( [ID],
[BED_UID],
[ADMISSION_DATE],
[DOMAIN_ID]) 
WHERE ([HAS_DISCHARGE]=(0))
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF EXISTS(SELECT 1 FROM sys.indexes WHERE name = 'IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_INT'))
	BEGIN
		DROP INDEX IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID ON DISCHARGE_INT;
	END
GO 

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_INT')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_INT] 
	(
		[APPOINTMENT_DATE] ASC,
		[PATIENT_UID] ASC,
		[VISTA_SITE_UID] ASC
	)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF EXISTS(SELECT 1 FROM sys.indexes WHERE name = 'IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_INT'))
	BEGIN
		DROP INDEX IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID ON DISCHARGE_INT;
	END
GO 

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_INT')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_INT] 
	(
		[APPOINTMENT_DATE] ASC,
		[STATUS] ASC,
		[IS_ACTIVE] ASC,
		[PATIENT_UID] ASC,
		[WARD_UID] ASC,
		[VISTA_SITE_UID] ASC
	)
INCLUDE ([HOSPITAL_LOCATION_UID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF EXISTS(SELECT 1 FROM sys.indexes WHERE name = 'IDX_IS_ACTIVE_ORDERABLE_ITEM_ID_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_REQ'))
	BEGIN
		DROP INDEX IDX_IS_ACTIVE_ORDERABLE_ITEM_ID_PATIENT_UID_WARD_UID_VISTA_SITE_UID ON DISCHARGE_REQ;
	END
GO 

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_ORDERABLE_ITEM_ID_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_ORDERABLE_ITEM_ID_PATIENT_UID_WARD_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_REQ] 
	(
		[IS_ACTIVE] ASC,
		[ORDERABLE_ITEM_ID] ASC,
		[PATIENT_UID] ASC,
		[WARD_UID] ASC,
		[VISTA_SITE_UID] ASC
	)
	INCLUDE ( [ID],
	[IEN]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_INCLUDE_ID_IEN_AND_ORDER_TEXT' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID_INCLUDE_ID_IEN_AND_ORDER_TEXT] ON [dbo].[DISCHARGE_REQ] 
	(
		[VISTA_SITE_UID] ASC
	)
	INCLUDE ( [ID],
	[IEN],
	[ORDER_TEXT]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF EXISTS(SELECT 1 FROM sys.indexes WHERE name = 'IDX_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('MOVEMENT_REQ'))
	BEGIN
		DROP INDEX IDX_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID ON MOVEMENT_REQ;
	END
GO 

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('MOVEMENT_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID] ON [dbo].[MOVEMENT_REQ] 
	(
		[IS_ACTIVE] ASC,
		[PATIENT_UID] ASC,
		[WARD_UID] ASC,
		[VISTA_SITE_UID] ASC
	)
	INCLUDE ( [ID],
	[IEN]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_INCLUDE_ID_AND_IEN' AND object_id = OBJECT_ID('MOVEMENT_REQ')) = 0
BEGIN
	CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID_INCLUDE_ID_AND_IEN] ON [dbo].[MOVEMENT_REQ] 
	(
		[VISTA_SITE_UID] ASC
	)
	INCLUDE ( [ID],
	[IEN]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF EXISTS(SELECT 1 FROM sys.indexes WHERE name = 'IDX_HAS_DISCHARGE_ID_BED_UID_WARD_UID_ADMISSION_DATE' AND object_id = OBJECT_ID('ADMISSION_EVN'))
	BEGIN
		DROP INDEX IDX_HAS_DISCHARGE_ID_BED_UID_WARD_UID_ADMISSION_DATE ON ADMISSION_EVN;
	END
GO 

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_MOVEMENT_ADMISSION' AND object_id = OBJECT_ID('MOVEMENT_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_MOVEMENT_ADMISSION] ON [dbo].[MOVEMENT_EVN] 
(
	[ADMISSION_ID] ASC
)
INCLUDE ( [IEN],
[BED_UID],
[MOVEMENT_DATE],
[DOMAIN_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_BED_UID_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_BED_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_EVN] 
(
	[BED_UID] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [IEN]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_BED_UID_COMPLETED_DATE' AND object_id = OBJECT_ID('BED_UNAVAILABLE')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_BED_UID_COMPLETED_DATE] ON [dbo].[BED_UNAVAILABLE] 
(
	[BED_UID] ASC,
	[COMPLETED_DATE] ASC
)
INCLUDE (ACT_ID)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_RETRIEVAL_METHOD_RETRIEVED_DATA_TYPE_STATUS_VISTA_ID_DATES' AND object_id = OBJECT_ID('JOB_AUDIT')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_RETRIEVAL_METHOD_RETRIEVED_DATA_TYPE_STATUS_VISTA_ID_DATES] ON [dbo].[JOB_AUDIT] 
(
      [VISTA_ID] ASC,
      [RETRIEVAL_METHOD] ASC,
      [RETRIEVED_DATA_TYPE] ASC,
      [STATUS] ASC,
      [START_DATE] ASC,
      [END_DATE] ASC
)
INCLUDE ([ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_RETRIEVAL_METHOD_RETRIEVED_DATA_TYPE_STATUS_VISTA_ID' AND object_id = OBJECT_ID('JOB_AUDIT')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_RETRIEVAL_METHOD_RETRIEVED_DATA_TYPE_STATUS_VISTA_ID] ON [dbo].[JOB_AUDIT] 
(
	  [VISTA_ID] ASC,
      [RETRIEVAL_METHOD] ASC,
      [RETRIEVED_DATA_TYPE] ASC,
      [STATUS] ASC
)
INCLUDE ([ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_JOB_AUDIT_ID' AND object_id = OBJECT_ID('JOB_AUDIT_PARAM')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_JOB_AUDIT_ID] ON [dbo].[JOB_AUDIT_PARAM] 
(
	  [JOB_AUDIT_ID] ASC
)
INCLUDE ([ID], [NAME], [VALUE])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_ADM_DATE_WITH_INCLUDE' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_ADM_DATE_WITH_INCLUDE] ON [dbo].[ADMISSION_EVN] 
(
	[VISTA_SITE_UID] ASC,
	[ADMISSION_DATE] ASC
)
INCLUDE ( [ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID])
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_COMPLETED_DATE' AND object_id = OBJECT_ID('BED_UNAVAILABLE')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_COMPLETED_DATE] ON [dbo].[BED_UNAVAILABLE] 
(
	[COMPLETED_DATE] ASC
)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_WARD_UID' AND object_id = OBJECT_ID('BED_UNAVAILABLE_WARD')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_WARD_UID] ON [dbo].[BED_UNAVAILABLE_WARD] 
(
	[WARD_UID] ASC
)
INCLUDE([BED_UNAVAILABLE_ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_REMOVED_DATE_REQUESTED_BED_UID' AND object_id = OBJECT_ID('WAITING_LIST')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_REMOVED_DATE_REQUESTED_BED_UID] ON [dbo].[WAITING_LIST] 
(
	 [REMOVED_DATE] ASC, [REQUESTED_BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_HLOC' AND object_id = OBJECT_ID('DISCHARGE_INT')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_HLOC] ON [dbo].[DISCHARGE_INT] 
(
	[IS_ACTIVE] ASC, 
	[HOSPITAL_LOCATION_UID] ASC,
	[APPOINTMENT_DATE] ASC
)
INCLUDE ([PATIENT_UID], [VISTA_SITE_UID], [WARD_UID], [STATUS] ) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_DISCH_DATE_WITH_INCLUDE' AND object_id = OBJECT_ID('DISCHARGE_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_DISCH_DATE_WITH_INCLUDE] ON [dbo].[DISCHARGE_EVN] 
(
	[VISTA_SITE_UID] ASC,
	[DISCHARGED_DATE] ASC
)
INCLUDE ([ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID], [ADMISSION_ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID' AND object_id = OBJECT_ID('MOVEMENT_EVN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID] ON [dbo].[MOVEMENT_EVN] 
(
	 [VISTA_SITE_UID] ASC, [MOVEMENT_DATE] ASC

)
INCLUDE ( [ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID], [ADMISSION_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_ID_STATUS' AND object_id = OBJECT_ID('JOB_AUDIT')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_VISTA_ID_STATUS] ON [dbo].[JOB_AUDIT] 
(
	[VISTA_ID] ASC,
	[STATUS] ASC
)
INCLUDE ( [END_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IEN_VISTA' AND object_id = OBJECT_ID('VISTA_INTEGRATION_LOG')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_IEN_VISTA] ON [dbo].[VISTA_INTEGRATION_LOG] 
(
	[IEN] ASC,
	[VISTA] ASC
)
INCLUDE ( [VISTA_FILE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
END
GO



IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VISTA_PATIENT_IEN]') AND type in (N'U'))
BEGIN
	CREATE TABLE [dbo].[VISTA_PATIENT_IEN](
		[ID] [int] IDENTITY(1,1) NOT NULL,
		[VISTA_CODE] [nvarchar](10) NOT NULL,
		[PATIENT_IEN] [nvarchar](50) NOT NULL,
	 CONSTRAINT [PK_VISTA_PATIENT_IEN] PRIMARY KEY CLUSTERED 
	(
		[ID] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
	) ON [PRIMARY]
END
GO


IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_WARD_UID_COMPLETED_DATE_REQUESTED_DATE_UTC' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE INDEX [IDX_WARD_UID_COMPLETED_DATE_REQUESTED_DATE_UTC] ON [dbo].[BED_CLEAN] 
([WARD_UID],[COMPLETED_DATE], [REQUESTED_DATE]) 
INCLUDE ([COMPLETED_BY], [CREATION_UTC_DATE])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_WARD_UID_COMPLETED_DATE_REQUESTED_DATE' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE INDEX [IDX_WARD_UID_COMPLETED_DATE_REQUESTED_DATE] ON [dbo].[BED_CLEAN] 
([WARD_UID],[COMPLETED_DATE], [REQUESTED_DATE]) 
INCLUDE ([ID], [DOMAIN_ID], [BED_UID], [TYPE_OF_CLEAN_ID], [MANUAL_REQUEST_ID], [ACCEPTED_DATE], [ACCEPTED_BY], [COMPLETED_BY], [LAST_EDITED_BY], [LAST_EDIT_DATE], [EMS_NOTIFY], [COMMENT], [COMMENTED_BY], [COMMENTED_DATE], [VACATED_DATE], [EVENT_IEN])	
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_WARD_UID_DATES_EVENT_IEN' AND object_id = OBJECT_ID('BED_CLEAN')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_WARD_UID_DATES_EVENT_IEN] ON [dbo].[BED_CLEAN] 
([WARD_UID],[COMPLETED_DATE],[ACCEPTED_DATE],[REQUESTED_DATE],[VACATED_DATE],[EVENT_IEN])
INCLUDE ([CREATION_UTC_DATE])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_VISTA_SITE_UID' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
CREATE INDEX [IDX_IS_ACTIVE_VISTA_SITE_UID] ON [dbo].[DISCHARGE_REQ] 
([IS_ACTIVE], [VISTA_SITE_UID]) 
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID], [ORDERED_DATE], [WARD_UID])	
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE] ON [dbo].[DISCHARGE_REQ] 
([IS_ACTIVE],[VISTA_SITE_UID],[ORDERED_DATE])
INCLUDE ([ID],[DOMAIN_ID],[IEN],[PATIENT_UID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_PATIENT_UID_IS_ACTIVE_VISTA_SITE_UID_WARD_UID' AND object_id = OBJECT_ID('DISCHARGE_REQ')) = 0
BEGIN
CREATE INDEX [IDX_PATIENT_UID_IS_ACTIVE_VISTA_SITE_UID_WARD_UID] ON [dbo].[DISCHARGE_REQ] 
([PATIENT_UID], [IS_ACTIVE], [VISTA_SITE_UID], [WARD_UID]) 
INCLUDE ([ID], [DOMAIN_ID], [IEN], [ORDERED_DATE])	
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE' AND object_id = OBJECT_ID('ADMISSION_REQ')) = 0
BEGIN
CREATE INDEX [IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE] ON [dbo].[ADMISSION_REQ] 
([IS_ACTIVE], [VISTA_SITE_UID],[ORDERED_DATE])
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_VISTA_SITE_UID' AND object_id = OBJECT_ID('ADMISSION_REQ')) = 0
BEGIN	
CREATE INDEX [IDX_IS_ACTIVE_VISTA_SITE_UID] ON [dbo].[ADMISSION_REQ] 
([IS_ACTIVE], [VISTA_SITE_UID]) 
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID], [ORDERED_DATE], [WARD_UID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_COMPLETED_DATE' AND object_id = OBJECT_ID('BED_UNAVAILABLE')) = 0
BEGIN	
CREATE INDEX [IDX_COMPLETED_DATE] ON [dbo].[BED_UNAVAILABLE] 
([COMPLETED_DATE])	
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_UNAVAIL_FRM_VISTA' AND object_id = OBJECT_ID('BED_UNAVAILABLE')) = 0
BEGIN
CREATE INDEX [IDX_IS_UNAVAIL_FRM_VISTA] ON [dbo].[BED_UNAVAILABLE] 
([IS_UNAVAILABLE_FROM_VISTA]) 
INCLUDE ([ACT_ID], [TYPE_ID])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_REMOVED_DATE' AND object_id = OBJECT_ID('WAITING_LIST')) = 0
BEGIN
CREATE INDEX [IDX_VISTA_SITE_UID_REMOVED_DATE] ON [dbo].[WAITING_LIST] 
([VISTA_SITE_UID], [REMOVED_DATE])	
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_ADMISSION_ID' AND object_id = OBJECT_ID('DISCHARGE_EVN')) = 0
BEGIN
CREATE INDEX [IDX_ADMISSION_ID] ON [dbo].[DISCHARGE_EVN] 
([ADMISSION_ID])	
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_BED_UID' AND object_id = OBJECT_ID('MOVEMENT_EVN')) = 0
BEGIN
CREATE INDEX [IDX_BED_UID] ON [dbo].[MOVEMENT_EVN] 
([BED_UID], [VISTA_SITE_UID],[MOVEMENT_DATE])
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_INITIAL_BED_UID_VISTA_SITE_UID_WITH_INCLUDE' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE INDEX IDX_INITIAL_BED_UID_VISTA_SITE_UID_WITH_INCLUDE ON [dbo].[ADMISSION_EVN] ([INITIAL_BED_UID], [VISTA_SITE_UID],[ADMISSION_DATE]) 
INCLUDE ([ID], [IEN], [INITIAL_WARD_UID])    
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_HAS_DISCHARGEWITH_INCLUDE' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE INDEX IDX_VISTA_SITE_UID_HAS_DISCHARGEWITH_INCLUDE ON [dbo].[ADMISSION_EVN] ([VISTA_SITE_UID], [HAS_DISCHARGE]) 
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID], [ENTERED_DATE], [BED_UID], [WARD_UID], [ADMISSION_DATE]) 
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_HAS_DISCHARGE_WARD_UID_WITH_INCLUDE' AND object_id = OBJECT_ID('ADMISSION_EVN')) = 0
BEGIN
CREATE INDEX IDX_VISTA_SITE_UID_HAS_DISCHARGE_WARD_UID_WITH_INCLUDE ON [dbo].[ADMISSION_EVN] ([VISTA_SITE_UID], [HAS_DISCHARGE],[WARD_UID]) 
INCLUDE ([PATIENT_UID])       
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_ADMISSION_ID' AND object_id = OBJECT_ID('SPECIALTY_TRANSFER')) = 0
BEGIN
CREATE INDEX IDX_ADMISSION_ID ON [dbo].[SPECIALTY_TRANSFER] ([ADMISSION_ID])  
END
GO  

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_WITH_INCLUDE' AND object_id = OBJECT_ID('TRANSFER_REQ')) = 0
BEGIN
CREATE INDEX IDX_VISTA_SITE_UID_WITH_INCLUDE ON [dbo].[TRANSFER_REQ] ([VISTA_SITE_UID]) INCLUDE ([ACT_ID])    
END
GO   

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE_WITH_INCLUDE' AND object_id = OBJECT_ID('MOVEMENT_REQ')) = 0
BEGIN
CREATE INDEX IDX_IS_ACTIVE_VISTA_SITE_UID_ORDERED_DATE_WITH_INCLUDE ON [dbo].[MOVEMENT_REQ] ([IS_ACTIVE], [VISTA_SITE_UID],[ORDERED_DATE]) INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID])  
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_VISTA_SITE_UID_WITH_INCLUDE' AND object_id = OBJECT_ID('BED_UNAVAILABLE')) = 0
BEGIN
CREATE INDEX IDX_VISTA_SITE_UID_WITH_INCLUDE ON [dbo].[BED_UNAVAILABLE] ([VISTA_SITE_UID]) INCLUDE ([ACT_ID], [BED_UID], [IS_UNAVAILABLE_FROM_VISTA])
END
GO     

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_IEN_VISTA_SITE_UID' AND object_id = OBJECT_ID('ADMISSION_REQ')) = 0
BEGIN
CREATE INDEX IDX_IEN_VISTA_SITE_UID ON [dbo].[ADMISSION_REQ] ([IEN], [VISTA_SITE_UID])  
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_CODE_SYSTEM_NAME_WITH_INCLUDE' AND object_id = OBJECT_ID('CONCEPT')) = 0
BEGIN
CREATE INDEX IDX_CODE_SYSTEM_NAME_WITH_INCLUDE ON [dbo].[CONCEPT] ([CODE_SYSTEM_NAME]) INCLUDE ([ID], [CODE])     
END
GO

IF (SELECT COUNT(*) FROM sys.indexes WHERE name='IDX_CREATION_DATE_WITH_INCLUDE' AND object_id = OBJECT_ID('ACT')) = 0
BEGIN
CREATE INDEX IDX_CREATION_DATE_WITH_INCLUDE ON [dbo].[ACT] ([CREATION_DATE]) INCLUDE ([ID], [PATIENT_UID], [CANCELED_DATE], [PARENT_ACT_ID], [FLOW_ID], [DOMAIN_ID])      
END
GO


